/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.ucode;

import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsData;
import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsExt;
import com.ibm.hsc.auiml.databeans.ucode.RepositoryItem;
import com.ibm.hsc.auiml.databeans.ucode.ResourceItem;
import com.ibm.hsc.auiml.databeans.ucode.UcodeSurveyException;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.Trace;
import java.util.ArrayList;

public class IOSurveyApplyUpdates {
    private static final String TRACE_MASKD = "JUCODECD";
    private static final String TRACE_MASKF = "JUCODECF";
    private static final String TRACE_MASKT = "JUCODECT";
    private static final short ERRID_0020 = 32;
    private static final short ERRID_0021 = 33;
    private static final short ERRID_0022 = 34;
    private IOSurveyResultsExt ioResultsExt;
    private IOSurveyResultsData resultsData;
    private Object threadLock = new Object();
    private Object dataLock = new Object();
    private ArrayList resourceThreadList;
    boolean updateErrors = false;
    private boolean userCancel = false;
    int threadCount = 0;

    public IOSurveyApplyUpdates(IOSurveyResultsData iOSurveyResultsData) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> IOSurveyApplyUpdates()");
        }
        this.resultsData = iOSurveyResultsData;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- IOSurveyApplyUpdates()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList applyUpdate(ArrayList arrayList, String string) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> IOSurveyApplyUpdates.applyUpdates()");
        }
        ArrayList arrayList2 = arrayList;
        boolean bl = false;
        int n = 0;
        String string2 = "";
        this.resourceThreadList = new ArrayList();
        try {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Selecting resources from checked list...");
            }
            Object[] objectArray = new Object[1];
            int n2 = arrayList2.size();
            for (n = 0; n < n2; ++n) {
                ResourceItem resourceItem = (ResourceItem)arrayList2.get(n);
                this.addToThreadList(resourceItem);
            }
            if (this.userCancel) {
                return arrayList2;
            }
            ArrayList arrayList3 = null;
            int n3 = this.resourceThreadList.size();
            int n4 = 0;
            for (n = 0; n < n3; ++n) {
                try {
                    arrayList3 = (ArrayList)this.resourceThreadList.get(n);
                    this.updateResourcesThread(arrayList3, string);
                    ++n4;
                    continue;
                }
                catch (Exception exception) {
                    if (1 > Trace.LEVEL) continue;
                    Trace.trace(TRACE_MASKD, "Exception " + exception + " creating thread " + this.threadCount);
                }
            }
            while (this.threadCount < n4) {
                try {
                    if (1 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKD, "Thread wait: current complete count is " + this.threadCount + " of " + n3);
                    }
                    Object object = this.threadLock;
                    synchronized (object) {
                        if (this.threadCount < n4) {
                            this.threadLock.wait();
                        }
                    }
                    if (1 > Trace.LEVEL) continue;
                    Trace.trace(TRACE_MASKD, "Thread notify complete for thread " + this.threadCount);
                }
                catch (Exception exception) {
                    if (1 > Trace.LEVEL) continue;
                    Trace.trace(TRACE_MASKD, "Exception " + exception + " waiting on thread " + this.threadCount);
                }
            }
        }
        catch (Exception exception) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Error applying update! " + exception);
            }
            this.updateErrors = true;
        }
        if (this.updateErrors) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "One or more updates were not applied");
            }
        } else if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "applyUpdate() processing was successfull!\n");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- IOSurveyApplyUpdates.applyUpdate()");
        }
        return arrayList2;
    }

    private void addToThreadList(ResourceItem resourceItem) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> IOSurveyApplyUpdates.addToThreadList()");
        }
        String string = resourceItem.getMTMS();
        String string2 = resourceItem.getPARID();
        boolean bl = false;
        if (resourceItem.getResourceType() == 6) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "addToThreadList adding BPA to list");
            }
            ArrayList<ResourceItem> arrayList = new ArrayList<ResourceItem>();
            arrayList.add(resourceItem);
            this.resourceThreadList.add(arrayList);
            return;
        }
        for (int i = 0; i < this.resourceThreadList.size(); ++i) {
            ArrayList arrayList = (ArrayList)this.resourceThreadList.get(i);
            ResourceItem resourceItem2 = (ResourceItem)arrayList.get(0);
            if (!string.equals(resourceItem2.getMTMS()) || !string2.equals(resourceItem2.getPARID())) continue;
            arrayList.add(0, resourceItem);
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Added " + string + "/" + string2 + " to beginning of existing list.");
            }
            bl = true;
        }
        if (!bl) {
            ArrayList<ResourceItem> arrayList = new ArrayList<ResourceItem>();
            arrayList.add(resourceItem);
            this.resourceThreadList.add(arrayList);
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Created " + string + "/" + string2 + " thread list.");
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- IOSurveyApplyUpdates.addToThreadList()");
        }
    }

    private void updateResourcesThread(final ArrayList arrayList, final String string) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                if (1 <= Trace.LEVEL) {
                    Trace.trace(IOSurveyApplyUpdates.TRACE_MASKT, "-> IOSurveyRunSurvey.updateResourcesThread.run()");
                }
                IOSurveyApplyUpdates.this.flashFirmware(arrayList, string);
            }
        });
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flashFirmware(ArrayList arrayList, String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        RepositoryItem repositoryItem = this.resultsData.getReposLevel();
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> IOSurveyApplyUpdates.flashFirmware()");
        }
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                Object[] objectArray;
                Object[] objectArray2;
                String string10 = "";
                String string11 = "";
                ResourceItem resourceItem = (ResourceItem)arrayList.get(i);
                if (repositoryItem.getReposType() == 0) {
                    string11 = resourceItem.getWEBDIR();
                } else if (repositoryItem.getReposType() == 4) {
                    string7 = repositoryItem.getLocation();
                    string8 = repositoryItem.getFTPUSER();
                    string9 = repositoryItem.getFTPPW();
                    string2 = repositoryItem.getDirPath();
                    if (!string2.endsWith("/")) {
                        string2 = string2 + "/";
                    }
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "FTP DirPath is :" + string2);
                    }
                } else if (repositoryItem.getReposType() == 1) {
                    string11 = resourceItem.getCDDIR();
                    string2 = repositoryItem.getDirPath();
                    if (!string2.endsWith("/")) {
                        string2 = string2 + "/";
                    }
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "CD DirPath is :" + string2);
                    }
                }
                string4 = resourceItem.getMTMS();
                String string12 = resourceItem.getRPMFILE();
                string5 = resourceItem.getPARID();
                String string13 = resourceItem.getIMGFILE();
                string3 = resourceItem.getDEVNM();
                string6 = string4 + "/" + string5 + "/" + string3;
                resourceItem.setReturnCode(0);
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Update for MTMS: " + string6);
                }
                try {
                    this.resultsData.getIOResultsExt().doRPMPackageInstall(string4, string12, string5, string, string2 + string11, string7, string8, string9);
                    try {
                        if (2 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKF, "doUcodeInstall() request was successfull for " + string6);
                        }
                        this.resultsData.getIOResultsExt().doUcodeInstall(string4, string3, string13, string5, string);
                        resourceItem.setReturnCode(0);
                        Object[] objectArray3 = new Object[]{string6};
                    }
                    catch (UcodeSurveyException ucodeSurveyException) {
                        if (2 <= Trace.LEVEL) {
                            Trace.trace(TRACE_MASKF, "doUcodeInstall() request failed for " + string6 + ". Exception during doUcodeInstall(). Exception is " + ucodeSurveyException);
                        }
                        objectArray2 = new Object[]{string6};
                        objectArray = ucodeSurveyException.getArgs();
                        string10 = objectArray == null ? HSCResourceBundleUtil.getMessage("UcodeBundleMessages", ucodeSurveyException.getKey(), "Error occurred processing update for " + string6) : HSCResourceBundleUtil.getMessage("UcodeBundleMessages", ucodeSurveyException.getKey(), "Error occurred processing update for " + string6, objectArray);
                        resourceItem.setReturnCode(8);
                        resourceItem.setReturnMessage(string10);
                        this.updateErrors = true;
                    }
                    continue;
                }
                catch (UcodeSurveyException ucodeSurveyException) {
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "doRPMPackageInstall() request failed for " + string6 + ". Exception during doRPMPackageInstall(). Exception is " + ucodeSurveyException);
                    }
                    objectArray2 = new Object[]{string6};
                    objectArray = ucodeSurveyException.getArgs();
                    string10 = objectArray == null ? HSCResourceBundleUtil.getMessage("UcodeBundleMessages", ucodeSurveyException.getKey(), "Error occurred processing update for " + string6) : HSCResourceBundleUtil.getMessage("UcodeBundleMessages", ucodeSurveyException.getKey(), "Error occurred processing update for " + string6, objectArray);
                    resourceItem.setReturnCode(8);
                    resourceItem.setReturnMessage(string10);
                    this.updateErrors = true;
                }
            }
        }
        catch (Throwable throwable) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "applyUpdate() request failed for " + string6 + ".  Unknown Exception during doUcodeInstall(). Exception is " + throwable);
            }
            Object[] objectArray = new Object[]{string6};
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Exception processing update: " + throwable);
            }
            this.updateErrors = true;
        }
        Object object = this.threadLock;
        synchronized (object) {
            ++this.threadCount;
            this.threadLock.notify();
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- IOSurveyApplyUpdates.flashFirmware()");
        }
    }
}

